package ca.utoronto.utm.midterm.dice2;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

import java.util.Observable;
import java.util.Observer;

public class DiceView extends HBox implements Observer {
    private Button roll = new Button("roll");
    private Label lDie1 = new Label(""+3);
    private Label lDie2 = new Label(""+3);

    public DiceView(DiceController controller) {
        roll.setOnAction(controller);
        this.setPadding(new Insets(5));
        this.setSpacing(10);
        this.getChildren().addAll(roll,lDie1,lDie2);
    }

    @Override
    public void update(Observable o, Object arg) {
        DiceModel dice = (DiceModel)o;
        lDie1.setText("" + dice.getDiceValue1());
        lDie2.setText("" + dice.getDiceValue2());
    }
}

