package ca.utoronto.utm.midterm.dice2;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

import java.util.Random;

public class DiceNonMVC extends Application implements EventHandler<ActionEvent>  {
    private Random randomSource = new Random();
    private Button roll = new Button("roll");
    private Label lDie1 = new Label(""+3);
    private Label lDie2 = new Label(""+3);

    @Override
    public void start(Stage stage) throws Exception {
        // CONTROLS
        // EVENT HANDLER CREATION
        // EVENT HANDLER HOOKUP
        roll.setOnAction(this);

        // LAYOUT
        HBox root = new HBox();
        root.setPadding(new Insets(5));
        root.setSpacing(10);
        root.getChildren().addAll(roll,lDie1,lDie2);

        // SCENE
        Scene scene = new Scene(root);
        // Scene scene = new Scene(root, 200, 200);

        // STAGE
        stage.setTitle("Dice");
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }

    @Override
    public void handle(ActionEvent event) {
        int die1 = randomSource.nextInt(6) + 1; // 0..5->1..6
        int die2 = randomSource.nextInt(6) + 1; // 0..5->1..6
        lDie1.setText("" + die1);
        lDie2.setText("" + die2);
    }
}

