package ca.utoronto.utm.midterm.dice2;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

import java.util.Observable;
import java.util.Observer;

public class DiceApplication extends Application {
    public static void main(String[] args) {
        launch(args);
    }
    @Override
    public void start(Stage stage) throws Exception {
        // MODEL
        DiceModel model = new DiceModel();

        // CONTROLLER
        DiceController controller = new DiceController(model);

        // VIEW
        DiceView view = new DiceView(controller);

        // Model/View hookup
        model.addObserver(view);

        // SCENE
        Scene scene = new Scene(view);

        // STAGE
        stage.setTitle("Dice");
        stage.setScene(scene);
        stage.show();
    }
}

