package ca.utoronto.utm.midterm.dice;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

import java.util.Observable;
import java.util.Observer;
import java.util.Random;

public class DiceView extends Application implements Observer {
    private Button roll = new Button("roll");
    private Label lDie1 = new Label(""+3);
    private Label lDie2 = new Label(""+3);

    public static void main(String[] args) {
        launch(args);
    }
    @Override
    public void start(Stage stage) throws Exception {
        // MODEL
        DiceModel model = new DiceModel();
        model.addObserver(this);

        // CONTROLLER
        DiceController controller = new DiceController(model);

        // EVENT HANDLER HOOKUP
        roll.setOnAction(controller);
        // VIEW
        // LAYOUT
        HBox root = new HBox();
        root.setPadding(new Insets(5));
        root.setSpacing(10);
        root.getChildren().addAll(roll,lDie1,lDie2);

        // SCENE
        Scene scene = new Scene(root);
        // Scene scene = new Scene(root, 200, 200);

        // STAGE
        stage.setTitle("Dice");
        stage.setScene(scene);
        stage.show();
    }

    @Override
    public void update(Observable o, Object arg) {
        DiceModel dice = (DiceModel)o;
        lDie1.setText("" + dice.getDiceValue1());
        lDie2.setText("" + dice.getDiceValue2());
    }
}

