package ca.utoronto.utm.Visitor;

import java.util.ArrayList;

public class Tree {

    public ArrayList<Tree> children;
    public Object value;

    public Tree(Object value) {
        this.value = value;
        this.children = new ArrayList<Tree>();
    }

    public Tree(Object value, ArrayList<Tree> children) {
        this.value = value;
        this.children = children;
    }

    public void addChild(Tree child) {
        this.children.add(child);
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}
