package ca.utoronto.utm.Composite;

import javafx.scene.canvas.Canvas;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

import java.sql.Array;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class PaintPanel extends Canvas implements EventHandler<MouseEvent>, Observer {
    private String mode="Circle";
    private PaintModel model;

    public Component s;

    public PaintPanel(PaintModel model) {
        super(300, 300);
        this.model=model;
        this.model.addObserver(this);

        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this);
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, this);
        this.addEventHandler(MouseEvent.MOUSE_MOVED, this);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, this);
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, this);
    }
    /**
     *  Controller aspect of this
     */
    public void setMode(String mode){
        this.mode=mode;
        System.out.println(this.mode);
    }

    @Override
    public void handle(MouseEvent mouseEvent) {
        // Later when we learn about inner classes...
        // https://docs.oracle.com/javafx/2/events/DraggablePanelsExample.java.htm

        EventType<MouseEvent> mouseEventType = (EventType<MouseEvent>) mouseEvent.getEventType();

        // "Circle", "Rectangle", "Square", "Squiggle", "Polyline"
        switch(this.mode){
            case "Circle":
                if(mouseEventType.equals(MouseEvent.MOUSE_PRESSED)) {
                    Point centre = new Point(mouseEvent.getX(), mouseEvent.getY());
                    this.s=new Circle(centre, 10);
                    this.model.addShape((Circle) this.s);
                    this.s=null;

                }
                break;
            case "Rectangle":
                if(mouseEventType.equals(MouseEvent.MOUSE_PRESSED)) {
                    Point centre = new Point(mouseEvent.getX(), mouseEvent.getY());
                    this.s=new Rectangle(centre, 40, 20);
                    this.model.addShape((Rectangle) this.s);
                    this.s=null;

                }
                break;
            case "Car":
                if(mouseEventType.equals(MouseEvent.MOUSE_PRESSED)) {
                    this.s = new Car(mouseEvent.getX(), mouseEvent.getY());

                    this.model.addShape((Car) this.s);
                    this.s=null;

                }
                break;
            case "Snowman":
                if(mouseEventType.equals(MouseEvent.MOUSE_PRESSED)) {
                    this.s = new Snowman(mouseEvent.getX(), mouseEvent.getY());

                    this.model.addShape((Snowman) this.s);
                    this.s=null;

                }
                break;
        }
    }
    @Override
    public void update(Observable o, Object arg) {

        GraphicsContext g2d = this.getGraphicsContext2D();
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());


        // Draw Shapes
        g2d.setFill(Color.GREEN);
        for(Component s: model.getShapes()){
           s.draw(g2d);
        }
    }
}
