package ca.utoronto.utm.designpatterns.visitor;

import java.util.ArrayList;

public class House {
	private ArrayList<Room> rooms=new ArrayList<Room>();
	public void accept(Visitor v) {
		for(Room r: rooms) {
			r.accept(v);
		}
	}
	
	House(){
		rooms.add(new Kitchen());
		rooms.add(new Bedroom());
		rooms.add(new Washroom());
		rooms.add(new Bedroom());
		rooms.add(new Bedroom());
		rooms.add(new Washroom());
	}
	public static void main(String [] args) {
		House house = new House();
		CleaningVisitor cv=new CleaningVisitor();
		house.accept(cv);
	}
	
}
