package ca.utoronto.utm.designpatterns.iterator;

import java.util.ArrayList;
import java.util.Iterator;

public class UseIterator {
	public static void main(String[] args) {

		// You have seen iterators before...
		ArrayList<Integer> ints = new ArrayList<Integer>();

		ints.add(3);
		ints.add(4);
		ints.add(7);

		// Could go through ints like this...

		for(int i=0;i<ints.size();i++){
			int k = ints.get(i);
			System.out.println(k);
		}
		
		// Alternatively
		for(int k: ints) {
			System.out.println(k);
		}
		
		// Above works because ArrayList<E> implements Iterable<E>
		// ArrayList<E> https://docs.oracle.com/javase/8/docs/api/java/util/ArrayList.html

		// Iterable<E> can return an Iterator<E> over something.
		// https://docs.oracle.com/javase/8/docs/api/java/lang/Iterable.html

		// Iterator<E> is used to go through something
		// https://docs.oracle.com/javase/8/docs/api/java/util/Iterator.html

		// Get an Iterator<Integer>
		Iterator<Integer> intsIterator = ints.iterator();

		// Use the Iterator<Integer>
		while(intsIterator.hasNext()) {
			System.out.println(intsIterator.next());
		}

		/**
		PositiveIntegerIterator i1 = new PositiveIntegerIterator();
		PositiveIntegerIterator i2 = new PositiveIntegerIterator();
		
		while(i1.hasNext()) {
			System.out.println("i1=" + i1.next());
			i2.next(); i2.next();
			System.out.println("i2=" + i2.next());
			
		}
		PositiveIntegers pi = new PositiveIntegers();
		for(Integer i:pi) {
			System.out.println(i);
		}
		PositiveIntegerIterator i3 = new PositiveIntegerIterator();
		for(int k:i3) {
	
			System.out.println("k="+k);
		}
		**/
		
		ChangeIterator ci = new ChangeIterator(623);
		while(ci.hasNext()) {
			int c = ci.next();
			System.out.println(c);	
		}
		
		Change change = new Change(623);
		for(int c:change) {
			System.out.println(c);
		}
	}
}
