package ca.utoronto.utm.designpatterns.iterator;

import java.util.Iterator;

public class Change implements Iterable<Integer> {
	private int amount;
	/**
	 * Construct a new Change Iterable, able to return 
	 * iterators for the specified amount.
	 * @param amount
	 */
	public Change(int amount) {
		this.amount = amount;
	}
	
	@Override
	public Iterator<Integer> iterator() {
		return new ChangeIterator(this.amount);
	}

}
