package ca.utoronto.utm.designpatterns.builder;
// Use Fluent Interface Idiom: no 'get' and return this for chaining
public class PizzaBuilder {
	boolean extraSauce=false;
	boolean extraCheese=false;
	boolean pepperoni=false;
	boolean tomatoes=false;
	boolean pineapple=false;
	boolean bacon = false;
	boolean anchovies = false;
	
	public PizzaBuilder extraSauce(){
		this.extraSauce=true;
		return this;
	}
	public PizzaBuilder extraCheese(){
		this.extraCheese=true;
		return this;
	}
	public PizzaBuilder pepperoni(){
		this.pepperoni=true;
		return this;
	}
	public PizzaBuilder tomato(){
		this.tomatoes=true;
		return this;
	}
	public PizzaBuilder pineapple(){
		this.pineapple=true;
		return this;
	}
	public PizzaBuilder bacon(){
		this.bacon=true;
		return this;
	}
	public PizzaBuilder anchovies(){
		this.anchovies=true;
		return this;
	}
	public Pizza build(){
		// Check if the proposed Pizza is consistent, 
		// throw an IllegalStateException if not.
		
		return new Pizza(this);
	}
}
