package ca.utoronto.utm.designpatterns.balloon;


public class RedBalloon implements Balloon{
    public int amount;
    public int capacity;
    public boolean isPopped;

    public RedBalloon() {
        this.amount = 0;
        this.capacity = 10;
        this.isPopped = false;
    }
    public RedBalloon(int capacity) {
        this();
        this.capacity = capacity;
    }
    public String getColor() {
        return "Red";
    }

    public int getAmount() {
        return amount;
    }

    public void inflate(int amount) {
        if(amount<0 || this.isPopped()){
            return;
        }
        this.amount = this.amount+amount;

        if(this.amount>this.capacity){
            this.pop();
        }
    }

    public void pop() {
        if(this.isPopped)return; // can't pop this twice
        this.amount=0;
        this.capacity=0;
        this.isPopped=true;
    }

    public int getCapacity() {
        return capacity;
    }

    public boolean isPopped() {
        return isPopped;
    }
    public String toString() {
        return "Red " + amount + "/" + capacity;
    }
}
