package ca.utoronto.utm.designpatterns.balloon;


public class GreenBalloon implements Balloon{
    private int capacity;
    private int amount;
    private boolean isPopped;


    public GreenBalloon() {
        this.capacity = 10;
        this.amount = 0;
        this.isPopped = false;
    }
    public GreenBalloon(int capacity){
        this();
        this.capacity = capacity;
    }
    public String getColor() {return "Green";}
    public int getAmount() {return amount; }
    public int getCapacity() { return capacity;}
    public boolean isPopped() { return isPopped;}

    public void inflate(int amount) {
        if(amount<0 || this.isPopped()){
            return;
        }
        this.amount = this.amount+amount;

        if(this.amount>this.capacity){
            this.pop();
        }
        //are you also making this an Observable?
        //if so, don't forget to setChanged() and notifyObservers()!!!
    }

    public void pop() {
        if(this.isPopped)return; // can't pop this twice
        this.amount=0;
        this.capacity=0;
        this.isPopped=true;
        //again, is this an observable?
    }
    public String toString() {
        return "Green " + amount + "/" + capacity;
    }
}
