package ca.utoronto.utm.designpatterns.balloon;

import java.util.ArrayList;

public class Client {

    public static void main(String[] args) {

        ArrayList<Balloon> balloons = new ArrayList<Balloon>();

        int color_i;
        String[] options = {"Green", "Red", "Blue"};
        for (int i = 0; i < 10; i++) {
            color_i = (int)(Math.random()*(options.length));
            balloons.add(BalloonFactory.createBalloon(options[color_i]));
        }
        present_balloons(balloons);
    }

    public static void present_balloons(ArrayList<Balloon> balloons) {
        System.out.println("Here are your balloons :)");
        for (int i = 0; i < balloons.size(); i++) {
            System.out.println(balloons.get(i));
        }
    }
}
