package ca.utoronto.utm.spaghettiClock;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.util.Duration;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

/**
 * A fully functional app that simply displays the current time
 * from the system's clock, but is structured in a rigid way.
 *
 * Your task: Restructure this code to comply with MVC design pattern specifications.
 * Note: This should NOT change the overall functionality, nor should the user see any difference before vs after.
 *
 * Create three new classes:
 *      1) Clock (Model) — holds time and updates every second.
 *      2) ClockView (View) — defines layout and visual elements.
 *      3) ClockController (Controller) — binds the model and view, handles start/stop.
 * Create a 4th App class
 *      Simplify the App class to only wire the MVC components and serve as the main class to run
 *
 * Ensure Clock has no UI code, and ClockView has no logic.
 */
public class BadClockApp extends Application {

    private boolean running = false;
    private Timeline timeline;
    private Label timeLabel;
    private Button startButton;
    private Button stopButton;
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    @Override
    public void start(Stage stage) {
        timeLabel = new Label(LocalTime.now().format(formatter));
        timeLabel.setFont(Font.font("Monospaced", 48));

        startButton = new Button("Start");
        stopButton = new Button("Stop");
        stopButton.setDisable(true);

        startButton.setOnAction(e -> {
            if (!running) {
                running = true;
                startButton.setDisable(true);
                stopButton.setDisable(false);
                startClock();
            }
        });

        stopButton.setOnAction(e -> {
            if (running) {
                running = false;
                startButton.setDisable(false);
                stopButton.setDisable(true);
                if (timeline != null) {
                    timeline.stop();
                }
            }
        });

        VBox root = new VBox(10, timeLabel, startButton, stopButton);
        root.setStyle("-fx-alignment: center; -fx-padding: 20;");
        Scene scene = new Scene(root, 300, 200);

        stage.setTitle("Badly Structured Clock");
        stage.setScene(scene);
        stage.show();
    }

    private void startClock() {
        timeline = new Timeline(new KeyFrame(Duration.seconds(1), e -> {
            String currentTime = LocalTime.now().format(formatter);
            timeLabel.setText(currentTime);
        }));
        timeline.setCycleCount(Timeline.INDEFINITE);
        timeline.play();
    }

    public static void main(String[] args) {
        launch(args);
    }
}
