package ca.utoronto.utm.numbersmvc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class TextController {
	private Numbers numbers;
	private MaxTextView mtv;
	private MinTextView mintv;
	
	public TextController() {
		this.numbers = new Numbers(); // model

		this.mtv = new MaxTextView(); // view
		this.mintv = new MinTextView(); // view 
		
		this.numbers.addObserver(mtv); // hookup model and view
		this.numbers.addObserver(mintv); 
	}
	
	private void control() {
		BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
		while(true) {
			try {
				System.out.println("Give me a number: ");
				String s = stdin.readLine();
				if(s.equals("quit")) break;
				
				int n = Integer.parseInt(s);
				
				this.numbers.add(n);
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	
	public static void main(String [] args) {
		TextController tc = new TextController();
		tc.control();
	}
}
