package ca.utoronto.utm.numbersmvc;

import java.util.ArrayList;
import java.util.Observable;

public class Numbers extends Observable {
	/** This is a model class **/
	private ArrayList<Integer> numbers;
	private int max, min;
	private double average;
	
	public Numbers() {
		this.numbers = new ArrayList<Integer>();
		this.max = this.min = 0;
		this.average = 0;
	}
	
	private double computeAverage() {
		int sum=0;
		for(int n:numbers) {
			sum+=n;
		}
		return ((double)sum)/numbers.size();
	}
	
	
	public void add(int n) {
		this.numbers.add(n);
		this.average = this.computeAverage();
		if(this.numbers.size()==1) {
			this.max = this.min = n;
		}
		if(n>this.max)this.max=n;
		if(n<this.min)this.min=n;
		
		this.setChanged();
		this.notifyObservers();
	}

	public ArrayList<Integer> getNumbers() {
		return numbers;
	}

	public void setNumbers(ArrayList<Integer> numbers) {
		this.numbers = numbers;
	}

	public int getMax() {
		return max;
	}

	public void setMax(int max) {
		this.max = max;
	}

	public int getMin() {
		return min;
	}

	public void setMin(int min) {
		this.min = min;
	}

	public double getAverage() {
		return average;
	}

	public void setAverage(double average) {
		this.average = average;
	}
}
