package ca.utoronto.utm.numbersmvc;

import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
// Exercise: Make max and min appear on the GUI, 
// add JLabels that are Views on the model.
// Hint: Create a new GUIMaxView which either extends JLabel,
// or holds onto both a JLabel and numbers.

public class GUIController2 {
	private Numbers numbers;
	private JButton addButton;
	private MaxTextView mtv;
	private MinTextView mintv;

	public GUIController2() {
		this.numbers = new Numbers(); // model

		this.mtv = new MaxTextView(); // view
		this.mintv = new MinTextView(); // view 
		
		this.numbers.addObserver(mtv); // hookup model and view
		this.numbers.addObserver(mintv); 
		
		JFrame frame = new JFrame("Numbers"); // Frame with title
		// What happens when we close the JFrame...
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// Layout components in frame left to right, top to bottom
		frame.getContentPane().setLayout(new FlowLayout());

		this.addButton = new JButton("Add");
		// Now make the button do something to the model
		// first an action listener for the button
		AddButtonActionListener abal = new AddButtonActionListener(this.numbers);
		
		this.addButton.addActionListener(abal);
		
		// add them to the contentPane
		frame.getContentPane().add(addButton);

		// Do the same with a JTextField
		JTextField t = new JTextField(20);
		frame.getContentPane().add(t);

		// tell the frame to pack in all the components
		// this is done according to the layout manager
		frame.pack();

		// lets see the frame
		frame.setVisible(true);
	}
	
	public static void main(String[] args) {
		// Schedule a job for the event-dispatching thread:
		// creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				GUIController2 gui = new GUIController2();
			}
		});
	}
}
