package ca.utoronto.utm.nonMVCballoon;


import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class BalloonGUI extends Application {
    public static void main(String[] args) {
        launch(args);
    }

    @Override
    public void start(Stage stage) throws Exception {
        // Create and hook up the Model, View and the controller


        // Model
        BadBalloon model_b1=new BadBalloon("Red", 100);
        BadBalloon model_b2=new BadBalloon("Green", 200);



        // View
        Label guiView1 = new Label(model_b1.getAmount() + " of " + model_b1.getCapacity());
        Label guiView2 = new Label(model_b2.getAmount() + " of " + model_b2.getCapacity());


        // Create the GUI controller to control the Model
        GridPane grid = new GridPane();
        //create and add buttons to the Layout (root node)
        //create EventHandlers for all controller components as needed
        grid.setHgap(10);
        grid.setVgap(10);


        Button b1, b2; // Two reference to JButton, no buttons exist yet!!

        // Create the buttons
        b1 = new Button("Inflate "+model_b1.getColor());
        b2 = new Button("Inflate "+model_b2.getColor());

        // add them to the contentPane
        grid.add(guiView1, 0, 0);
        grid.add(b1, 1, 0);
        grid.add(guiView2, 0, 1);
        grid.add(b2, 1, 1);


        b1.setOnAction(e -> {
            model_b1.inflate(10);
            guiView1.setText(model_b1.getAmount() + " of " + model_b1.getCapacity());
            if(model_b1.isPopped()){
                Button jb = (Button)e.getSource();
                jb.setDisable(true);
            }

        });
        b2.setOnAction(e -> {
            model_b2.inflate(10);
            guiView2.setText(model_b2.getAmount() + " of " + model_b2.getCapacity());
            if(model_b2.isPopped()){
                Button jb = (Button)e.getSource();
                jb.setDisable(true);
            }
        });


        // SCENE
        Scene scene = new Scene(grid, 200, 80);

        // STAGE
        stage.setTitle("Balloons");
        stage.setScene(scene);
        stage.show();

    }


}