package ca.utoronto.utm.balloonmvc;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class GUIApp2 extends Application {
	public static void main(String[] args) {
		launch(args);
	}

    @Override
	public void start(Stage stage) throws Exception {
		// Create and hook up the Model, View and the controller

		
		// Model
		Balloon model_b1=new Balloon("Red", 100);
		Balloon model_b2=new Balloon("Green", 200);


        // View
        GUIView guiView1 = new GUIView(model_b1.getAmount() + " of " + model_b1.getCapacity());
        GUIView guiView2 = new GUIView(model_b2.getAmount() + " of " + model_b2.getCapacity());

		// Hook the model to the view.
		model_b1.addObserver(guiView1);
        model_b2.addObserver(guiView2);

				
		// Create the GUI controller to control the Model
		GridPane grid = new GridPane();
        //create and add buttons to the Layout (root node)
        //create EventHandlers for all controller components as needed
		grid.setHgap(10); 
		grid.setVgap(10);

		
		Button b1, b2; // Two reference to JButton, no buttons exist yet!!

		// Create the buttons
        b1 = new Button("Inflate Red Balloon");
        b2 = new Button("Inflate Green Balloon");


		// add them to the contentPane
		grid.add(guiView1, 0, 0);
		grid.add(b1, 1, 0);
		grid.add(guiView2, 0, 1);
        grid.add(b2, 1, 1);


		// Create button press event handlers
		ButtonInflateEventHandler mb1 = new ButtonInflateEventHandler(model_b1);
		ButtonInflateEventHandler mb2 = new ButtonInflateEventHandler(model_b2);

		// Tell the buttons who they should call when they are pressed.
		// That is, hook up the controller to the Model.
		b1.addEventHandler(ActionEvent.ACTION, mb1);
        b2.addEventHandler(ActionEvent.ACTION, mb2);

		
		//grid.setMinSize(Region.USE_PREF_SIZE, Region.USE_PREF_SIZE );
		
		// SCENE
		Scene scene = new Scene(grid, 200, 80); 

		// STAGE
		stage.setTitle("Balloons");
		stage.setScene(scene);
		stage.show();
		
	}
}