package ca.utoronto.utm.designpatterns.observerobservable;

// Model
public class MNumberGuessGame extends Observable {
	public static final String GUESS_LOW ="LOW";
	public static final String GUESS_CORRECT = "CORRECT";
	public static final String GUESS_HIGH ="HIGH";
	public static final String NOT_STARTED = "NOT STARTED";
	
	private int secretNumber;
	private String gameState;
	private int  numMoves;
	
	public MNumberGuessGame() {
		this.secretNumber = 7;
		this.gameState=NOT_STARTED;
		this.numMoves = 0;
	}
	
	public void guess(int g) {
		if(g<this.secretNumber) {
			this.gameState = GUESS_LOW;
		} else if(g==this.secretNumber) {
			this.gameState = GUESS_CORRECT;

		} else this.gameState = GUESS_HIGH;
		this.numMoves++;
		this.notifyObservers();
	}

	public String getGameState() {
		return gameState;
	}

	public int getNumMoves() {
		return numMoves;
	}
}
