package ca.utoronto.utm.designpatterns.observerobservable;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class GuessGameGUIApp extends Application {
	// REMEMBER: To run this in the lab put 
	// --module-path "/usr/share/openjfx/lib" --add-modules javafx.controls,javafx.fxml
	// in the run configuration under VM arguments.
	
	public static void main(String[] args) {
		launch(args);
	}

	public void start(Stage stage) throws Exception {
		// Create and hook up the Model, View and the controller
		
		// View which observes the model
		VGameStateLabel gameStateLabel = new VGameStateLabel("Just Started");
		TextField usersGuessTextField = new TextField();
		
		// Model
		MNumberGuessGame guessGame = new MNumberGuessGame();

		// Hook the model to the view.
		guessGame.attach(gameStateLabel);
		
		// Create the GUI controller to control the Model
		
		// Create the buttons
		Button guessButton = new Button("Guess");

		// add them to the contentPane
		// LAYOUT
		HBox flow= new HBox();
				
		flow.setPadding(new Insets(10));
	    flow.setSpacing(10);

	    flow.getChildren().add(usersGuessTextField);
		flow.getChildren().add(guessButton);
		flow.getChildren().add(gameStateLabel);

		// Create button press event handlers
		CGuessButtonHandler guessButtonHandler = new CGuessButtonHandler(usersGuessTextField, guessGame);

		// Tell the buttons who they should call when they are pressed.
		// That is, hook up the controller to the Model.
		guessButton.addEventHandler(ActionEvent.ACTION, guessButtonHandler);

		// SCENE
		Scene scene = new Scene(flow); 
		// Scene scene = new Scene(root, 200, 200); 

		// STAGE
		stage.setTitle("GuessGame");
		stage.setScene(scene);
		stage.show();
	}
}