package ca.utoronto.utm.designpatterns.iterator;

import java.util.Iterator;

public class ChangeIterator implements Iterator<Integer> {

	private int amount;
	public ChangeIterator(int amount) {
		this.amount = amount;
	}
		
	@Override
	public boolean hasNext() {
		return this.amount != 0;
	}

	@Override
	public Integer next() {
		// Think about simplifying this!!
		int change = 0;
		if(this.amount >= 500) {
			change = 500;
			this.amount -= change;
		} else if(this.amount >= 200) {
			change = 200;
			this.amount -= change;
		} else if(this.amount >= 100) {
			change = 100;
			this.amount -= change;
		} else if(this.amount >= 25) {
			change = 25;
			this.amount -= change;
		} else if(this.amount >= 10) {
			change = 10;
			this.amount -= change;
		} else if(this.amount >= 5) {
			change = 5;
			this.amount -= change;
		} else if(this.amount >= 1) {
			change = 1;
			this.amount -= change;
		}
		return change;
	}
}
