package ca.utoronto.utm.designpatterns.composite;

public class ODigit implements AODigit {
	private AODigit next;
	private int digit;
	
	public ODigit(AODigit next) {
		this.next=next;
		this.digit=0;
	}

	@Override
	public void increment() {
		this.digit++;
		if(this.digit==9) {
			this.digit=0;
			this.next.increment();
		}
		
	}

	@Override
	public String stringRep() {
		return this.next.stringRep()+this.digit;
	}
}
